﻿//////////////////////////////////////////////
// LuaThread.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class LogManager ;
}

namespace nkScripts
{
	class Environment ;
	class Script ;
	class ScriptObjectReference ;
}

namespace nkTasks
{
	class Thread ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../Scheduler/LuaSchedulerTask.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <memory>
#include <unordered_map>

/// Class ------------------------------------

namespace nkAstraeus::nkTasksWrap
{
	class LuaThread final
	{
		public :

			// Constructor, destructor
			LuaThread (LogManager* targetLogManager) noexcept ;
			~LuaThread () ;

			// Manipulations
			void addTask (nkMemory::UniquePtr<LuaSchedulerTask> task, const nkScripts::ScriptObjectReference& luaRef) ;
			void releaseTaskRef (LuaSchedulerTask* task) ;
			void run () ;

			// Utils
			void runScript (nkScripts::Script* script) ;

		private :

			// Thread nkTasks
			nkMemory::UniquePtr<nkTasks::Thread> _thread ;
			// Environnement à part
			nkMemory::UniquePtr<nkScripts::Environment> _env ;

			// Les références sur les tasks actives
			std::unordered_map<LuaSchedulerTask*, nkScripts::ScriptObjectReference> _taskRefs ;
	} ;
}